/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.questkilltask;

import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.KillTask;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.muon.questkilltask.DamageTracker;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_3222;

public class QuestProcessor {
    private static List<KillTask> killTasks;

    public QuestProcessor(List<KillTask> killTasks) {
        QuestProcessor.killTasks = null;
    }

    public static void invalidateKillTasks() {
        killTasks = null;
    }

    private void initKillTasks() {
        if (killTasks == null && ServerQuestFile.INSTANCE != null) {
            killTasks = ServerQuestFile.INSTANCE.collect(KillTask.class);
        }
    }

    public boolean shouldProcessKill(class_1309 entity) {
        boolean hasContributors;
        if (entity.method_37908().method_8608()) {
            return false;
        }
        this.initKillTasks();
        if (killTasks == null || killTasks.isEmpty()) {
            return false;
        }
        DamageTracker.KillContributors contributors = DamageTracker.getKillContributors(entity);
        boolean bl = hasContributors = !contributors.damagers().isEmpty() || !contributors.healers().isEmpty() || !contributors.tanks().isEmpty();
        return hasContributors;
    }

    public ServerQuestFile getQuestFile() {
        ServerQuestFile questFile = ServerQuestFile.INSTANCE;
        if (questFile == null) {
            return null;
        }
        this.initKillTasks();
        if (killTasks == null || killTasks.isEmpty()) {
            return null;
        }
        return questFile;
    }

    public TeamData getKillerTeam(class_1282 source, ServerQuestFile questFile) {
        class_1297 class_12972 = source.method_5529();
        if (!(class_12972 instanceof class_3222)) {
            return null;
        }
        class_3222 killer = (class_3222)class_12972;
        TeamData killerTeam = questFile.getOrCreateTeamData((class_1297)killer);
        return killerTeam;
    }

    public void processDamagingTeams(class_1309 entity, ServerQuestFile questFile, TeamData killerTeam) {
        HashSet<UUID> processedTeams = new HashSet<UUID>();
        DamageTracker.KillContributors contributors = DamageTracker.getKillContributors(entity);
        HashSet<UUID> allContributors = new HashSet<UUID>();
        allContributors.addAll(contributors.damagers());
        allContributors.addAll(contributors.healers());
        allContributors.addAll(contributors.tanks());
        for (UUID playerUUID : allContributors) {
            this.processPlayerContribution(playerUUID, entity, questFile, killerTeam, processedTeams);
        }
    }

    private void processPlayerContribution(UUID playerUUID, class_1309 entity, ServerQuestFile questFile, TeamData killerTeam, Set<UUID> processedTeams) {
        class_3222 player = questFile.server.method_3760().method_14602(playerUUID);
        if (player == null) {
            return;
        }
        TeamData playerTeam = questFile.getOrCreateTeamData((class_1297)player);
        if (!this.isValidTeam(playerTeam, killerTeam)) {
            return;
        }
        if (!processedTeams.add(playerTeam.getTeamId())) {
            return;
        }
        this.updateTeamKillTasks(playerTeam, entity);
    }

    private boolean isValidTeam(TeamData playerTeam, TeamData killerTeam) {
        return playerTeam != null && !playerTeam.isLocked();
    }

    private void updateTeamKillTasks(TeamData team, class_1309 entity) {
        for (KillTask task : killTasks) {
            if (!this.canCompleteTask(team, task)) continue;
            task.kill(team, entity);
        }
    }

    private boolean canCompleteTask(TeamData team, KillTask task) {
        return team.getProgress((Task)task) < task.getMaxProgress() && team.canStartTasks(task.getQuest());
    }
}

